/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis.adapter;

import io.swagger.annotations.ApiModelProperty;
import java.util.concurrent.TimeUnit;
import top.doudou.common.redis.RedisUtil;
import top.doudou.core.exception.CustomException;

public class SmsStrategyAdapter {
    @ApiModelProperty(value="24h\u5185\u540c\u4e00\u624b\u673a\u53f7\u6700\u591a\u53d1\u9001\u597d\u591a\u6761\u77ed\u4fe1")
    private int dayMax = 5;
    @ApiModelProperty(value="\u597d\u591a\u79d2\u5185\u4e0d\u80fd\u91cd\u590d\u53d1\u9001")
    private int coolingTime = 20;
    private RedisUtil redisUtil;
    public static final String CODE_DAY_COUNT = "sms:code:count:";
    public static final String CODE_COOLING = "sms:code:cooling:";

    public SmsStrategyAdapter(RedisUtil redisUtil, int dayMax, int coolingTime) {
        this.dayMax = dayMax;
        this.coolingTime = coolingTime;
        this.redisUtil = redisUtil;
    }

    public boolean handler(String mobile) {
        String coolingKey;
        String countKey = CODE_DAY_COUNT + mobile;
        int count = 1;
        if (this.redisUtil.hasKey(countKey)) {
            Integer temp = (Integer)this.redisUtil.get(countKey);
            if (temp > this.dayMax) {
                throw new CustomException("24\u5c0f\u65f6\u5185\u53d1\u9001\u6b21\u6570\u8fc7\u591a\uff01");
            }
            count = temp + 1;
        }
        if (this.redisUtil.hasKey(coolingKey = CODE_COOLING + mobile)) {
            throw new CustomException("\u77ed\u65f6\u95f4\u5185\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
        }
        this.redisUtil.set(coolingKey, 1, 20L);
        this.redisUtil.set(countKey, count, 1L, TimeUnit.DAYS);
        return true;
    }
}

