/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class JsonRedisSerializer<T>
implements RedisSerializer<T> {
    private static ParserConfig defaultRedisConfig = new ParserConfig();
    private Class<T> type;

    public JsonRedisSerializer(Class<T> type) {
        this.type = type;
    }

    public byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return new byte[0];
        }
        return JSON.toJSONString(t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}).getBytes(IOUtils.UTF8);
    }

    public T deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        String str = new String(bytes, IOUtils.UTF8);
        return (T)JSON.parseObject((String)str, this.type, (ParserConfig)defaultRedisConfig, (Feature[])new Feature[0]);
    }

    static {
        defaultRedisConfig.setAutoTypeSupport(true);
    }
}

