/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.doudou.common.redis.RedisUtil;
import top.doudou.core.respond.Result;
import top.doudou.core.util.FastAssert;

@Api(value="redis\u7684\u63a7\u5236\u5c42", tags={"redis\u7684\u63a7\u5236\u5c42"})
@RestController
@RequestMapping(value={"/redis"})
public class RedisController {
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u7ed9\u6307\u5b9akey\u8bbe\u7f6e\u7f13\u5b58\u503c", notes="\u7ed9\u6307\u5b9akey\u8bbe\u7f6e\u7f13\u5b58\u503c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u7f13\u5b58\u7684key", dataType="String", required=true), @ApiImplicitParam(name="value", value="\u7f13\u5b58\u7684\u503c", dataType="Object", required=true), @ApiImplicitParam(name="time", value="\u7f13\u5b58\u7684\u65f6\u95f4(\u9ed8\u8ba45\u5206\u949f)", dataType="Long", required=false)})
    @GetMapping(value={"set"})
    public Result<Boolean> set(@RequestParam(value="key") String key, @RequestParam(value="value") Object value, @RequestParam(value="time") Long time) {
        FastAssert.notEmpty((Object)key, (String)"key not null");
        if (null == time) {
            time = 300L;
        }
        return Result.ok((Object)this.redisUtil.set(key, value, time));
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9akey\u7684value\u503c", notes="\u83b7\u53d6\u6307\u5b9akey\u7684value\u503c")
    @ApiImplicitParam(name="key", value="\u7f13\u5b58\u7684\u952e", dataType="String", required=true)
    @GetMapping(value={"get"})
    public Result<Object> get(@RequestParam(value="key") String key) {
        return Result.ok((Object)this.redisUtil.get(key));
    }

    @ApiOperation(value="\u5220\u9664\u7f13\u5b58\u6307\u5b9a\u7f13\u5b58", notes="\u5220\u9664\u7f13\u5b58\u6307\u5b9a\u7f13\u5b58")
    @ApiImplicitParam(name="key", value="\u7f13\u5b58\u7684\u952e", dataType="String[]", required=true)
    @GetMapping(value={"del"})
    public Result<Boolean> del(String ... key) {
        this.redisUtil.del(key);
        return Result.ok((Object)true);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u503c", notes="\u8bbe\u7f6e\u503c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u7f13\u5b58\u7684\u952e", dataType="String", required=true), @ApiImplicitParam(name="value", value="\u7f13\u5b58\u7684\u503c", dataType="Object", required=true)})
    @GetMapping(value={"set/value"})
    public Result<Boolean> set(@RequestParam(value="key") String key, @RequestParam(value="value") Object value) {
        this.redisUtil.set(key, value);
        return Result.ok((Object)true);
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u7cca\u7684\u6240\u6709key\u503c", notes="\u83b7\u53d6\u6a21\u7cca\u7684\u6240\u4ee5key\u503c")
    @ApiImplicitParam(name="key", value="\u7f13\u5b58\u7684\u952e", dataType="String", required=true)
    @GetMapping(value={"keys"})
    public Result<Set<String>> keys(@RequestParam(value="key") String key) {
        Set<String> scan = this.redisUtil.scan(key);
        return Result.ok(scan);
    }
}

