/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.redis.lock;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.context.ApplicationContextUtils;
import top.doudou.common.redis.transaction.TransactionMode;
import top.doudou.common.redis.transaction.TransactionUtils;
import top.doudou.common.redis.utils.RLockThreadLocal;

public class LockUtils {
    private static final Logger log = LoggerFactory.getLogger(LockUtils.class);
    private static RedissonClient redissonClient = (RedissonClient)ApplicationContextUtils.getBean(RedissonClient.class);

    public static boolean tryLock(String key) {
        log.debug("[Cluster-Lock] - \u5c1d\u8bd5\u5206\u5e03\u5f0f\u9501 - {}", (Object)key);
        RLock lock = redissonClient.getLock(key);
        if (lock != null && lock.tryLock()) {
            log.debug("[Cluster-Lock-Succ] - \u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f - {}", (Object)key);
            RLockThreadLocal.setRLock(lock);
            return true;
        }
        log.warn("[Cluster-Lock-Fail] - \u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 - {}", (Object)key);
        return false;
    }

    public static boolean lockSync(String key) {
        log.debug("[Cluster-Lock] - \u963b\u585e\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501 - {} - {}", (Object)key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        RLock lock = redissonClient.getLock(key);
        if (lock != null) {
            while (!lock.tryLock()) {
            }
            log.debug("[Cluster-Lock-Succ] - \u963b\u585e\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f - {} - {}", (Object)key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
            RLockThreadLocal.setRLock(lock);
            return true;
        }
        log.warn("[Cluster-Lock-Fail] - \u963b\u585e\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 - {} - {}", (Object)key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        throw new RuntimeException("\u83b7\u5f97\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff01");
    }

    public static boolean lockTime(String key, Long time, TimeUnit unit) {
        log.debug("[Cluster-Lock] - \u8d85\u65f6\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501 - {} - {}", (Object)key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        RLock lock = redissonClient.getLock(key);
        try {
            if (lock.tryLock(time.longValue(), unit)) {
                log.debug("[Cluster-Lock-Succ] - \u8d85\u65f6\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f - {} - {}", (Object)key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
                RLockThreadLocal.setRLock(lock);
                return true;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.warn("[Cluster-Lock-Fail] - \u8d85\u65f6\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 - {} - {}", (Object)key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        return false;
    }

    public static boolean unlock() {
        log.debug("[Cluster-unLock] - \u89e3\u9664\u5206\u5e03\u5f0f\u9501");
        RLock rLock = RLockThreadLocal.getRLock();
        RLockThreadLocal.clear();
        if (rLock != null && rLock.isLocked()) {
            rLock.unlock();
            log.debug("[Cluster-unLock-Succ] - \u89e3\u9664\u5206\u5e03\u5f0f\u9501\u6210\u529f - {}", (Object)rLock.getName());
            return true;
        }
        log.debug("[Cluster-unLock-Succ] - \u89e3\u9664\u5206\u5e03\u5f0f\u9501\u5931\u8d25 - {}", (Object)rLock);
        return false;
    }

    public static LockTransaction lockTransaction(String key) {
        LockUtils.lockSync(key);
        return new LockTransaction();
    }

    public static class LockTransaction {
        public LockTransaction mode(TransactionMode mode) {
            TransactionUtils.startTransaction(mode);
            return this;
        }

        public <T> T exec(Supplier<T> supplier) {
            try {
                T result = supplier.get();
                TransactionUtils.commit();
                T t = result;
                return t;
            }
            catch (Exception e) {
                TransactionUtils.rollback();
                throw e;
            }
            finally {
                LockUtils.unlock();
            }
        }
    }
}

