package top.doudou.common.redis.adapter;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import top.doudou.common.redis.RedisUtil;
import top.doudou.core.exception.CustomException;

import java.util.concurrent.TimeUnit;

/**
 * @Description 短信策略
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 20:03
 */
@Data
public class SmsStrategyAdapter {

    //防止恶意请求  发送策略
    @ApiModelProperty("24h内同一手机号最多发送好多条短信")
    private int dayMax = 5;

    @ApiModelProperty("好多秒内不能重复发送")
    private int coolingTime = 20;


    private RedisUtil redisUtil;

    public static final String CODE_DAY_COUNT = "sms:code:count:";

    public static final String CODE_COOLING = "sms:code:cooling:";

    public SmsStrategyAdapter(RedisUtil redisUtil,int dayMax,int coolingTime){
        this.dayMax = dayMax;
        this.coolingTime = coolingTime;
        this.redisUtil = redisUtil;
    }

    public boolean handler(String mobile){
        String countKey = CODE_DAY_COUNT + mobile;
        int count = 1;
        if(redisUtil.hasKey(countKey)){
            Integer temp = (Integer)redisUtil.get(countKey);
            if(temp > dayMax){
                throw new CustomException("24小时内发送次数过多！");
            }
            count = temp + 1;
        }
        String coolingKey = CODE_COOLING + mobile;
        if (redisUtil.hasKey(coolingKey)) {
            throw new CustomException("短时间内，请勿重复发送验证码！");
        }
        redisUtil.set(coolingKey,1,coolingTime);
        redisUtil.set(countKey,count,1,TimeUnit.DAYS);
        return true;
    }

}

