package top.doudou.common.redis.config;

import org.springframework.cache.interceptor.KeyGenerator;
import top.doudou.core.builder.JsonBuilder;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.StringJoiner;

/**
 * @Description 自定义cacheKey
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-12-09 15:50
 */
public class FastCacheKeyGenerator implements KeyGenerator {

    @Override
    public Object generate(Object target, Method method, Object... params) {
        StringJoiner sj = new StringJoiner(":","","");
        //包名
//        sj.add(target.getClass().getPackage().getName());
        //简单的名字
        sj.add(target.getClass().getSimpleName());
        //方法名
        sj.add(method.getName());
        Parameter[] parameters = method.getParameters();
        if (params.length > 0) {
            int i = 0;
            // 参数值
            for (Object object : params) {
                if(null == object){
                    sj.add(addParam(i,parameters[i],object));
                    i++;
                    continue;
                }
                sj.add(addParam(i,parameters[i],object));
                i++;
            }
        } else {
            sj.add("NO_PARAM_KEY");
        }
        return sj.toString();
    }


    /**
     * 添加参数
     * @param count 次数
     * @param parameter 参数
     * @param obj  参数的值
     * @return
     */
    private String addParam(int count,Parameter parameter,Object obj){
        if(null == parameter){
            return "";
        }
        StringJoiner sj = new StringJoiner("","","");
        if(count >= 1){
            sj.add("&");
        }
        sj.add(parameter.getName()).add("=").add(null == obj ? "" : JsonBuilder.gson().toJson(obj));
        return sj.toString();
    }

}