package top.doudou.common.redis.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.doudou.common.redis.RedisUtil;
import top.doudou.core.respond.Result;
import top.doudou.core.util.FastAssert;

import java.util.Set;

/**
 * @Description redis的控制层
 * @author 傻男人<244191347@qq.com>
 * @Date 2020-11-26 9:31
 * @Version V1.0
 */
@Api(value = "redis的控制层", tags = "redis的控制层")
@RestController
@RequestMapping("/redis")
public class RedisController {

    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value = "给指定key设置缓存值", notes = "给指定key设置缓存值")
    @ApiImplicitParams({@ApiImplicitParam(name = "key", value = "缓存的key", dataType = "String", required = true),
            @ApiImplicitParam(name = "value", value = "缓存的值", dataType = "Object", required = true),
            @ApiImplicitParam(name = "time", value = "缓存的时间(默认5分钟)", dataType = "Long", required = false)})
    @GetMapping("set")
    public Result<Boolean> set(@RequestParam("key")String key, @RequestParam("value")Object value, @RequestParam("time")Long time) {
        FastAssert.notEmpty(key,"key not null");
        if(null == time){
            time = 300L;
        }
        return Result.ok(redisUtil.set(key,value,time));
    }

    @ApiOperation(value = "获取指定key的value值", notes = "获取指定key的value值")
    @ApiImplicitParam(name = "key", value = "缓存的键", dataType = "String", required = true)
    @GetMapping("get")
    public Result<Object> get(@RequestParam("key")String key) {
        return Result.ok(redisUtil.get(key));
    }

    @ApiOperation(value = "删除缓存指定缓存", notes = "删除缓存指定缓存")
    @ApiImplicitParam(name = "key", value = "缓存的键", dataType = "String[]", required = true)
    @GetMapping("del")
    public Result<Boolean> del(@RequestParam("key")String... key) {
        redisUtil.del(key);
        return Result.ok(true);
    }

    @ApiOperation(value = "设置值", notes = "设置值")
    @ApiImplicitParams({@ApiImplicitParam(name = "key", value = "缓存的键", dataType = "String", required = true),
            @ApiImplicitParam(name = "value", value = "缓存的值", dataType = "Object", required = true)})
    @GetMapping("set/value")
    public Result<Boolean> set(@RequestParam("key")String key,@RequestParam("value")Object value) {
        redisUtil.set(key,value);
        return Result.ok(true);
    }

    @ApiOperation(value = "获取模糊的所有key值", notes = "获取模糊的所以key值")
    @ApiImplicitParam(name = "key", value = "缓存的键", dataType = "String", required = true)
    @GetMapping("keys")
    public Result<Set<String>> keys(@RequestParam("key")String key) {
        Set<String> scan = redisUtil.scan(key);
        return Result.ok(scan);
    }

}
