package top.doudou.common.redis.handler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Component;
import top.doudou.common.redis.entity.RedisInfo;

import java.util.*;

/**
 * @Description
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-03-05 17:13
 */
@Component
public class FastRedisHandler {

    @Autowired
    private RedisConnectionFactory redisConnectionFactory;

    /**
     * 获取redis中DB数量
     * 当前连接库中的DB数量
     * @return
     */
    public Long getDBSize(){
        return redisConnectionFactory.getConnection().dbSize();
    }

    /**
     * Redis详细信息
     * @return
     */
    public List<RedisInfo> getRedisInfo(){
        RedisConnection connection = redisConnectionFactory.getConnection();
        Properties info = connection.info();
        Set<Map.Entry<Object, Object>> entries = info.entrySet();
        List<RedisInfo> result = new ArrayList<>();
        entries.forEach(item->result.add(new RedisInfo(String.valueOf(item.getKey()),String.valueOf(item.getValue()))));
        Long aLong = connection.dbSize();
        result.add(new RedisInfo("dbSize",String.valueOf(aLong)));
        return result;
    }
}
