package top.doudou.common.redis.lock;

import java.util.concurrent.TimeUnit;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2020-11-20 16:20
 * @Version: 1.0
 * @Description: redis锁
 */
public interface RedisLock {

    /**
     * 尝试加锁
     * @param key 加锁的key
     * @param timeout  超时的时间
     * @param unit 时间的单位
     * @return
     */
    boolean tryLock(String key, long timeout, TimeUnit unit);


    /**
     * 解锁操作
     * @param key 加锁的key
     */
    void releaseLock(String key);
    
}