package top.doudou.mybatis.plus.context;

import java.util.Optional;

/**
 * @Description 租户信息上下文
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-24 9:38
 * @Version V1.0
 */
public class TenantContextHolder {

    private  static ThreadLocal<TenantContext> context = new InheritableThreadLocal();
    private  static ThreadLocal<TenantContext> back = new InheritableThreadLocal();

    public static  Long getTenantId(){
        return getOp().map(v->v.getTenantId()).orElse(0L);
    }

    public static Long getOrganizationId(){
        return getOp().map(v->v.getOrganizationId()).orElse(0L);
    }


    public static void set(Long tenantId,Long organizationId){
        set(tenantId,organizationId,false);
    }
    public static void set(Long tenantId,Long organizationId,boolean filter){
        context.set(new TenantContext(tenantId,organizationId,filter));
    }

    /**
     * 保存一个备份
     * @param orgId
     * @param subOrgId
     */
    public static void setAndSave(Long orgId,Long subOrgId){
        setAndSave(orgId,subOrgId,false);
    }
    public static void setAndSave(Long orgId,Long subOrgId,boolean filter){
        back.set(context.get());
        set(orgId,subOrgId,filter);
    }

    /**
     * 是否清除所有的
     * @param all
     */
    public static void clear(boolean all){
        if(all){
            context.remove();
            back.remove();
        }else{
            context.set(back.get());
        }
    }

    /**
     * 默认清除所有的上下文
     */
    public static void clear(){
        clear(true);
    }

    public static Optional<TenantContext> getOp(){
        return  Optional.ofNullable(context.get());
    }

    public static TenantContext get(){
        return getOp().orElse(null);
    }

    public static class TenantContext{
        Long tenantId;
        Long organizationId;
        /**
         * 是否过滤
         */
        boolean filter;

        public TenantContext(Long tenantId){
            this(tenantId,0L);
        }
        public TenantContext(Long tenantId, Long organizationId) {
            this(tenantId,organizationId,false);
        }
        public TenantContext(Long tenantId, Long organizationId,boolean filter) {
            this.tenantId = tenantId;
            this.organizationId = organizationId;
            this.filter = filter;
        }

        public Long getTenantId() {
            return tenantId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public Long getOrganizationId() {
            return organizationId;
        }

        public void setOrganizationId(Long organizationId) {
            this.organizationId = organizationId;
        }

        public boolean isFilter() {
            return filter;
        }

        public void setFilter(boolean filter) {
            this.filter = filter;
        }
    }
}
