/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.tenant;

import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.mybatis.plus.context.TenantContextHolder;
import top.doudou.mybatis.plus.tenant.annotation.CancelTenant;

public class SqlParserFilter
implements ISqlParserFilter {
    private static final Logger log = LoggerFactory.getLogger(SqlParserFilter.class);
    Map<String, Optional<CancelTenant>> cacheCancelTenant = new ConcurrentHashMap<String, Optional<CancelTenant>>();

    public boolean doFilter(MetaObject metaObject) {
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        boolean result = TenantContextHolder.getOp().map(v -> v.isFilter()).orElse(false);
        if (result) {
            return true;
        }
        Optional<CancelTenant> cancelTenant = this.getCancelTenant(ms.getId());
        Boolean flag = cancelTenant.map(v -> v.value()).orElse(false);
        log.info("\u79df\u6237\u89e3\u6790\u7684\u4fe1\u606f\u4e3a:" + flag);
        return flag;
    }

    protected Optional<CancelTenant> getCancelTenant(String msId) {
        if (this.cacheCancelTenant.containsKey(msId)) {
            return this.cacheCancelTenant.get(msId);
        }
        Optional<CancelTenant> cached = this.msIdToCancelTenant(msId);
        this.cacheCancelTenant.put(msId, cached);
        return cached;
    }

    protected Optional<CancelTenant> msIdToCancelTenant(String msId) {
        int lastSplit = msId.lastIndexOf(".");
        String className = msId.substring(0, lastSplit);
        String methodName = msId.substring(lastSplit + 1);
        Class<?> cls = null;
        Optional<CancelTenant> tenant = Optional.empty();
        try {
            cls = Class.forName(className);
            CancelTenant tenant1 = Arrays.stream(cls.getMethods()).filter(method -> method.getName().equals(methodName)).findFirst().get().getAnnotation(CancelTenant.class);
            tenant = Optional.ofNullable(tenant1);
        }
        catch (Exception tenant1) {
            // empty catch block
        }
        if (!tenant.isPresent()) {
            try {
                CancelTenant tenant2 = cls.getAnnotation(CancelTenant.class);
                tenant = Optional.ofNullable(tenant2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tenant;
    }
}

