package top.doudou.mybatis.plus.entity;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2020/8/25 14:47
 * @Version: 1.0
 * @Description:
 */
@Data
public class SqlLogDto implements Serializable {

    /**
     * 请务必注意该对象 使用->释放 原则
     */
    private static final ThreadLocal<SqlLogDto> SQL_DATE = new InheritableThreadLocal<>();

    private SqlLogDto(){}

    /**
     * 耗时
     */
    private Long cost;

    /**
     * sql id
     */
    private String sqlId;

    private String shortSqlId;

    /**
     * sql语句
     */
    private String sentence;

    /**
     * 请求的随机id
     */
    private String requestId;

    /**
     * 返回的行数
     */
    private Integer rows;


    /**
     * 返回的结果
     */
    private Object result;

    /**
     * 格式化好的sql结果集
     */
    private SqlResultDto formatSqlRetDto;


    public static void setCurrent(SqlLogDto data) {
        SQL_DATE.set(data);
    }

    /**
     * 移除当前线程操作日志对象
     */
    public static void removeCurrent() {
        SQL_DATE.remove();
    }

    public static SqlLogDto getCurrent() {
        SqlLogDto data = SQL_DATE.get();
        if (data == null) {
            data = new SqlLogDto();
            SQL_DATE.set(data);
        }
        return SQL_DATE.get();
    }

    public static void setCurFormatSqlRetDto(SqlResultDto formatSqlRetDto) {
        getCurrent().setFormatSqlRetDto(formatSqlRetDto);
    }

    public static void setCurSentence(String sentence) {
        getCurrent().setSentence(sentence);
    }

    public static void setCurCost(Long cost) {
        getCurrent().setCost(cost);
    }

    public static void setCurRows(Integer rows) {
        getCurrent().setRows(rows);
    }

    public static void setCurResult(Object result) {
        getCurrent().setResult(result);
    }

    public static void setCurRequestId(String requestId) {
        getCurrent().setRequestId(requestId);
    }


    public static void setCurSqlId(String sqlId){
        getCurrent().setSqlId(sqlId);
        if(StringUtils.isBlank(sqlId)){
            return;
        }
        String[] split = sqlId.split("\\.");
        int length = split.length;
        String shortSqlId = length >= 2 ? split[length-2]+"."+split[length-1] : sqlId;
        getCurrent().setShortSqlId(shortSqlId);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String requestId = this.getRequestId();
        if(StringUtils.isNotEmpty(requestId)){
            result.append(result.length() == 0 ? requestId : "    "+requestId);
        }
        Long cost = this.getCost();
        if(null != cost){
            result.append(result.length() == 0 ? cost : "    "+cost);
        }
        String shortSqlId = this.getShortSqlId();
        if(StringUtils.isNotEmpty(shortSqlId)){
            result.append(result.length() == 0 ? shortSqlId : "    "+shortSqlId);
        }
        String sentence = this.getSentence();
        if(StringUtils.isNotEmpty(sentence)){
            result.append(result.length() == 0 ? sentence : "    "+sentence);
        }
        Integer rows = this.getRows();
        if(null != rows){
            result.append(result.length() == 0 ? rows : "    "+rows);
        }
        if(null != this.getFormatSqlRetDto()){
            result.append(this.getFormatSqlRetDto());
        }
        Object rtn = this.getResult();
        if(null != rtn){
            result.append(result.length() == 0 ? rtn : "    "+rtn);
        }
        return result.toString();
    }
}
