/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus;

import com.baomidou.mybatisplus.annotation.TableField;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperProxyFactory;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import top.doudou.base.util.ServletUtils;
import top.doudou.core.exception.CustomException;
import top.doudou.core.exception.ExceptionUtils;
import top.doudou.core.properties.CustomLogProperties;
import top.doudou.core.random.RandomUtils;
import top.doudou.core.system.SystemMonitorUtil;
import top.doudou.core.util.FieldUtils;
import top.doudou.core.util.HumpUtil;
import top.doudou.core.util.file.WriteLogToFile;
import top.doudou.mybatis.plus.entity.SqlLogDto;
import top.doudou.mybatis.plus.entity.SqlResultDto;
import top.doudou.mybatis.plus.utils.MyBatisUtils;

@Intercepts(value={@Signature(type=org.apache.ibatis.executor.Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=org.apache.ibatis.executor.Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=org.apache.ibatis.executor.Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
@Component
@ConditionalOnClass(value={MapperProxyFactory.class})
@EnableConfigurationProperties(value={CustomLogProperties.class})
public class MybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisInterceptor.class);
    @Autowired
    private Executor executorService;
    @Autowired
    private CustomLogProperties customLogProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        Object statement = MyBatisUtils.getNoProxyTarget(invocation.getTarget());
        if (statement instanceof Statement) {
            return this.showResult(invocation, statement);
        }
        if (statement instanceof MappedStatement) {
            return this.showSql(invocation, statement);
        }
        return invocation.proceed();
    }

    private Object showSql(Invocation invocation, Object statement) throws InvocationTargetException, IllegalAccessException {
        try {
            MappedStatement mappedStatement = (MappedStatement)statement;
            Object parameter = null;
            if (invocation.getArgs().length > 1) {
                parameter = invocation.getArgs()[1];
            }
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            Configuration configuration = mappedStatement.getConfiguration();
            SqlLogDto.setCurSentence(this.getSqLSentence(configuration, boundSql));
            SqlLogDto.setCurSqlId(mappedStatement.getId());
        }
        catch (Exception mappedStatement) {
            // empty catch block
        }
        long start = System.currentTimeMillis();
        Object result = invocation.proceed();
        long cost = System.currentTimeMillis() - start;
        SqlLogDto.setCurCost(cost);
        this.getUUIDFromRequest();
        if (result instanceof List) {
            SqlLogDto.setCurRows(((List)result).size());
        } else {
            SqlLogDto.setCurResult(result);
        }
        this.printSql();
        return result;
    }

    private void getUUIDFromRequest() {
        String uuid = null;
        try {
            uuid = Optional.ofNullable(ServletUtils.getRequest().getAttribute("request-uuid")).map(Object::toString).orElse("");
        }
        catch (Exception e) {
            uuid = "temp" + RandomUtils.randomUUID((int)12);
        }
        SqlLogDto.setCurRequestId(uuid);
    }

    private String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    private String getSqLSentence(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (CollectionUtils.isNotEmpty((Collection)parameterMappings) && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(this.getParameterValue(obj)));
                        continue;
                    }
                    sql = sql.replaceFirst("\\?", "\u7f3a\u5931");
                }
            }
        }
        return sql;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        if (target instanceof org.apache.ibatis.executor.Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object showResult(Invocation invocation, Object statementObj) throws InvocationTargetException, IllegalAccessException {
        List results = (List)invocation.proceed();
        try {
            if (CollectionUtils.isNotEmpty((Collection)results)) {
                Class<?> cls = this.getRowClass(results);
                SqlResultDto sqlResultDto = new SqlResultDto();
                List fields = FieldUtils.getAllNoStaticFinalTransientFields(cls);
                int sum = 0;
                String queryField = this.getQueryField(SqlLogDto.getCurrent().getSentence());
                ArrayList queryFieldList = Lists.newArrayList();
                StringJoiner header = new StringJoiner(",  ", " Columns:  ", "");
                if (!"".equals(queryField) && !queryField.trim().equals("*")) {
                    Arrays.stream(queryField.split(",")).forEach(item -> queryFieldList.add(item.trim()));
                }
                ArrayList matchFieldList = Lists.newArrayList();
                for (Object result : results) {
                    if (null == result) continue;
                    StringJoiner row = new StringJoiner(",  ", " Row:  ", "");
                    for (Field field : fields) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        if (sum == 0) {
                            if (CollectionUtils.isNotEmpty((Collection)queryFieldList)) {
                                String matchField = this.matchField(field.getName(), queryFieldList);
                                if (!StringUtils.isNotEmpty((CharSequence)matchField)) continue;
                                header.add(matchField);
                                matchFieldList.add(field);
                            } else {
                                TableField annotation = field.getAnnotation(TableField.class);
                                header.add(null != annotation ? annotation.value() : field.getName());
                            }
                        }
                        if (!matchFieldList.contains(field)) continue;
                        Object value = FieldUtils.getFieldValueNoException((Field)field, result);
                        row.add(null == value ? null : value.toString());
                    }
                    if (sum == 0) {
                        if (CollectionUtils.isEmpty((Collection)fields)) {
                            header.add(queryField);
                        }
                        sqlResultDto.setHeader(header.toString());
                    }
                    if (results.size() == 1) {
                        row.add(result.toString());
                    }
                    sqlResultDto.setColumnList(row.toString());
                    ++sum;
                }
                SqlLogDto.setCurFormatSqlRetDto(sqlResultDto);
            }
        }
        catch (CustomException customException) {
            log.error(customException.getMessage());
        }
        catch (Exception e) {
            log.error(ExceptionUtils.toString((Exception)e));
        }
        finally {
            return results;
        }
    }

    private String matchField(String fieldName, List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        String lowerFieldName = fieldName.toLowerCase();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String temp;
            boolean itemIndex_;
            String item;
            String result = item = iterator.next();
            boolean fieldIndex_ = fieldName.indexOf("_") != -1;
            boolean bl = itemIndex_ = item.indexOf("_") != -1;
            if (fieldIndex_ && itemIndex_ && lowerFieldName.equals(item.toLowerCase())) {
                return result;
            }
            if (fieldIndex_ && !itemIndex_ && (temp = HumpUtil.camelCaseName((String)fieldName)).toLowerCase().equals(item.toLowerCase())) {
                return result;
            }
            if (!fieldIndex_ && itemIndex_ && lowerFieldName.equals((temp = HumpUtil.camelCaseName((String)item)).toLowerCase())) {
                return result;
            }
            if (fieldIndex_ || itemIndex_ || !lowerFieldName.equals(item.toLowerCase())) continue;
            return result;
        }
        return null;
    }

    private String getRowInfo(String row, Object result) {
        return row + result.toString();
    }

    private String getHeaderInfo(String headerInfo, String sentence) {
        return headerInfo + this.getQueryField(sentence);
    }

    private String getQueryField(String sentence) {
        if (StringUtils.isBlank((CharSequence)sentence)) {
            return "";
        }
        if (!(sentence = sentence.trim().toLowerCase()).startsWith("select")) {
            return "";
        }
        return sentence.split("from")[0].replaceFirst("select", "");
    }

    private Class<?> getRowClass(List<Object> list) {
        for (Object obj : list) {
            if (null == obj) continue;
            return obj.getClass();
        }
        throw new CustomException("\u6240\u6709\u5c5e\u6027\u5747\u4e3a\u7a7a");
    }

    private StringJoiner getFormatSql() {
        SqlLogDto sqlLogDto = SqlLogDto.getCurrent();
        if (null == sqlLogDto) {
            return null;
        }
        if (this.customLogProperties.isPrintSql()) {
            StringJoiner stringJoiner = new StringJoiner(SystemMonitorUtil.getLineBreak(), "", "");
            String requestId = sqlLogDto.getRequestId();
            requestId = StringUtils.isNotBlank((CharSequence)requestId) ? "[" + requestId + "] " : "";
            stringJoiner.add("--------------< sql\u6267\u884c\u7684\u8bed\u53e5" + requestId + " >--------------").add("===>  sql id                " + sqlLogDto.getSqlId());
            String sentence = sqlLogDto.getSentence();
            if (StringUtils.isNotEmpty((CharSequence)sentence) && sentence.length() >= 800 && !sentence.startsWith("select") && !sentence.startsWith("SELECT")) {
                stringJoiner.add("===>  sql sentence          sql sentence length greater than 800");
            } else {
                stringJoiner.add("===>  sql sentence          " + sentence);
            }
            stringJoiner.add("===>  sql cost(ms): " + sqlLogDto.getCost() + (null != sqlLogDto.getRows() ? "     rows: " + sqlLogDto.getRows() : ""));
            return stringJoiner;
        }
        if (this.customLogProperties.isWriteSqlToFile()) {
            WriteLogToFile.asyncLogToFile((String)this.customLogProperties.getFilePath(this.customLogProperties.getSqlLogName()), (String)sqlLogDto.toString());
        }
        return null;
    }

    private StringJoiner getSqlResult() {
        StringJoiner stringJoiner = new StringJoiner(SystemMonitorUtil.getLineBreak(), "", "");
        SqlResultDto sqlResultDto = SqlLogDto.getCurrent().getFormatSqlRetDto();
        if (null == sqlResultDto) {
            return null;
        }
        if (null != sqlResultDto && this.customLogProperties.isPrintSqlResult()) {
            List<String> columnList;
            if (StringUtils.isNotBlank((CharSequence)sqlResultDto.getHeader())) {
                stringJoiner.add("===> " + sqlResultDto.getHeader());
            }
            if (CollectionUtils.isNotEmpty(columnList = sqlResultDto.getColumnList())) {
                columnList.forEach(item -> stringJoiner.add("===> " + item));
            }
        }
        return stringJoiner;
    }

    private void printSql() {
        try {
            StringJoiner formatSql = this.getFormatSql();
            if (null == formatSql) {
                return;
            }
            StringJoiner sqlResult = this.getSqlResult();
            if (null != sqlResult) {
                formatSql.merge(sqlResult);
            }
            log.info(formatSql.toString());
        }
        finally {
            SqlLogDto.removeCurrent();
        }
    }
}

