package top.doudou.mybatis.plus.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import top.doudou.core.exception.CustomException;

import java.util.concurrent.Callable;

/**
 * @Description mybatisplus自定义填充公共字段
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-15 11:17
 * @Version V1.0
 */
public abstract class AbsMybatisDataAutoFill implements MetaObjectHandler {

    /**
     * 检查是否包含该属性
     * @param metaObject
     * @param attribute 属性
     * @return
     */
    public boolean checkAttribute(MetaObject metaObject, String attribute) {
        return metaObject.hasGetter(attribute);
    }

    /**
     * 属性是否已经有默认值
     * @param metaObject
     * @param property 属性
     * @return  如果不包含该属性，也直接返回false
     */
    public boolean hasDefaultValue(MetaObject metaObject, String property) {
        if (checkAttribute(metaObject, property)) {
            Object obj = metaObject.getValue(property);
            return null == obj;
        }
        return false;
    }

    /**
     * 给该属性赋值，如果存在值则不改变
     * since 3.3.0 使用 strictInsertFill插入
     * @param metaObject
     * @param attribute 属性
     * @param defaultValue 默认值
     */
    @Deprecated
    public void assignment(MetaObject metaObject, String attribute, Object defaultValue) {
        if (checkAttribute(metaObject, attribute)) {
            Object obj = metaObject.getValue(attribute);
            if (null == obj) {
                metaObject.setValue(attribute, defaultValue);
            }
        }
    }

    /**
     * 给该属性赋值，如果存在值则不改变
     * since 3.3.0 使用 strictInsertFill插入
     * @param metaObject
     * @param attribute  属性
     * @param fun  生成默认值的方法
     */
    @Deprecated
    public void assignment(MetaObject metaObject, String attribute, Callable<Object> fun){
        if (checkAttribute(metaObject, attribute)) {
            Object obj = metaObject.getValue(attribute);
            if (null == obj) {
                Object call = call(fun);
                metaObject.setValue(attribute, call);
            }
        }
    }

    /**
     * 给该属性赋值，不管存在与否都更新值(强制更新)
     * @param metaObject
     * @param attribute 属性
     * @param defaultValue 默认值
     */
    public void forceUpdate(MetaObject metaObject, String attribute, Object defaultValue) {
        if (checkAttribute(metaObject, attribute)) {
            metaObject.setValue(attribute, defaultValue);
        }
    }


    public void forceUpdate(MetaObject metaObject, String attribute, Callable<Object> fun) {
        if (checkAttribute(metaObject, attribute)) {
            Object call = call(fun);
            metaObject.setValue(attribute, call);
        }
    }

    private Object call(Callable<Object> fun){
        try {
            Object call = fun.call();
            return call;
        }catch (Exception e){
            throw new CustomException(e.getMessage());
        }
    }

}
