package top.doudou.mybatis.plus.utils;

import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

/**
 * @Description MetaObject工具类
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-10-22 10:33
 * @Version V1.0
 */
public class MyBatisUtils {

    /**
     * 获得最终的目标对象
     * @return
     */
    public static Object getNoProxyTarget(Object target){
        //进行对象的绑定
        MetaObject metaObject = SystemMetaObject.forObject(target);
        while(metaObject.hasGetter("h")){
            target = metaObject.getValue("h.target");
            metaObject = SystemMetaObject.forObject(target);
        }
        return target;
    }

    /**
     * 获取主表form下标的位置
     * @param sql
     * @return -1:表示没有from 其他表示form的下标位置
     */
    public static int getFromIndex(int beginIndex, String sql){
        int fromIndex = sql.indexOf("from", beginIndex);
        if (fromIndex == -1) return -1;

        int count = 0;//括号的计数器
        int selectIndex = fromIndex;//当前需要查询括号的位置下标
        int bIndex = -1;//正括号的下标
        while((bIndex = sql.lastIndexOf("(", selectIndex)) != -1){
            count++;
            selectIndex = bIndex - 1;
        }
        selectIndex = fromIndex;//当前需要查询括号的位置下标
        int eIndex = -1;//反括号的下标
        while((eIndex = sql.lastIndexOf(")", selectIndex)) != -1){
            count--;
            selectIndex = eIndex - 1;
        }
        if (count == 0) {
            return fromIndex;
        } else {
            return getFromIndex(fromIndex + 1, sql);
        }
    }

    /**
     * 获取sql的查询总数的语句
     * @param sql
     * @return
     */
    public static String getSqlTotal(String sql){
        int index = getFromIndex(0, sql);
        return "select count(*) as total " + sql.substring(index);
    }

}