package top.doudou.mybatis.plus.encrypt.handle;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @Description 身份证号码脱敏处理
 *     将身份证号码中间出身年月日变成****号  513123190312031234-->513123********1234
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-14 11:34
 */
public class IdCardNoDesensitizationHandler extends BaseTypeHandler<String> implements SensitiveHandler<String> {

    /**
     * 脱敏处理
     *
     * @param data 脱敏数据
     */
    @Override
    public String handler(String data) {
        return data.replaceAll("(\\w{6})\\w{8}([\\w || \\w{4}])","$1********$2");
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String String, JdbcType jdbcType) throws SQLException {

    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String columnValue = rs.getString(columnName);
        return getRealValue(columnValue);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String columnValue = rs.getString(columnIndex);
        return getRealValue(columnValue);
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String columnValue = cs.getString(columnIndex);
        return getRealValue(columnValue);
    }

    private String getRealValue(String columnValue){
        return StringUtils.isBlank(columnValue) ? columnValue : handler(columnValue);
    }

    public static void main(String[] args) {
        IdCardNoDesensitizationHandler idCardNoDesensitizationHandler = new IdCardNoDesensitizationHandler();
        System.out.println(idCardNoDesensitizationHandler.handler("513123190312031AAA"));
    }
    
}
