/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import top.doudou.core.exception.CustomException;
import top.doudou.core.exception.ExceptionUtils;

public class MyApplicationStartedListener
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(MyApplicationStartedListener.class);

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        DataSource dataSource = (DataSource)applicationContext.getBean(DataSource.class);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            log.error(ExceptionUtils.toString((Exception)e));
            throw new CustomException("\u83b7\u53d6\u6570\u636e\u5e93\u7684\u8fde\u63a5\u5f02\u5e38", new Object[]{e});
        }
        ScriptRunner runner = new ScriptRunner(connection);
        try {
            Reader resourceAsReader = Resources.getResourceAsReader((String)"schema_data.sql");
            runner.runScript(resourceAsReader);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.toString((Exception)e));
        }
    }
}

