/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Optional;

public class TenantContextHolder {
    private static ThreadLocal<TenantContext> context = new TransmittableThreadLocal();
    private static ThreadLocal<TenantContext> back = new TransmittableThreadLocal();

    public static Long getTenantId() {
        return TenantContextHolder.getOp().map(v -> v.getTenantId()).orElse(0L);
    }

    public static Long getOrganizationId() {
        return TenantContextHolder.getOp().map(v -> v.getOrganizationId()).orElse(0L);
    }

    public static void set(Long tenantId, Long organizationId) {
        TenantContextHolder.set(tenantId, organizationId, false);
    }

    public static void set(Long tenantId, Long organizationId, boolean filter) {
        context.set(new TenantContext(tenantId, organizationId, filter));
    }

    public static void setAndSave(Long orgId, Long subOrgId) {
        TenantContextHolder.setAndSave(orgId, subOrgId, false);
    }

    public static void setAndSave(Long orgId, Long subOrgId, boolean filter) {
        back.set(context.get());
        TenantContextHolder.set(orgId, subOrgId, filter);
    }

    public static void clear(boolean all) {
        if (all) {
            context.remove();
            back.remove();
        } else {
            context.set(back.get());
        }
    }

    public static void clear() {
        TenantContextHolder.clear(true);
    }

    public static Optional<TenantContext> getOp() {
        return Optional.ofNullable(context.get());
    }

    public static TenantContext get() {
        return TenantContextHolder.getOp().orElse(null);
    }

    public static class TenantContext {
        Long tenantId;
        Long organizationId;
        boolean filter;

        public TenantContext(Long tenantId) {
            this(tenantId, 0L);
        }

        public TenantContext(Long tenantId, Long organizationId) {
            this(tenantId, organizationId, false);
        }

        public TenantContext(Long tenantId, Long organizationId, boolean filter) {
            this.tenantId = tenantId;
            this.organizationId = organizationId;
            this.filter = filter;
        }

        public Long getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public Long getOrganizationId() {
            return this.organizationId;
        }

        public void setOrganizationId(Long organizationId) {
            this.organizationId = organizationId;
        }

        public boolean isFilter() {
            return this.filter;
        }

        public void setFilter(boolean filter) {
            this.filter = filter;
        }
    }
}

