package top.doudou.mybatis.plus.encrypt.handle;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @Description 名字脱敏处理
 *    李三-->李*  李三四-->李*四
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-14 11:34
 */
public class NameDesensitizationHandler extends BaseTypeHandler<String> implements SensitiveHandler<String> {

    /**
     * 脱敏处理
     *
     * @param data 脱敏数据
     */
    @Override
    public String handler(String data) {
        if(StringUtils.isBlank(data) || StringUtils.length(data) == 1){
            return data;
        }
        if(StringUtils.length(data) == 2){
            return StringUtils.left(data,1)+"*";
        }else {
            return StringUtils.left(data,1)+"*"+StringUtils.right(data,1);
        }

    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String String, JdbcType jdbcType) throws SQLException {

    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String columnValue = rs.getString(columnName);
        return getRealValue(columnValue);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String columnValue = rs.getString(columnIndex);
        return getRealValue(columnValue);
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String columnValue = cs.getString(columnIndex);
        return getRealValue(columnValue);
    }

    private String getRealValue(String columnValue){
        return StringUtils.isBlank(columnValue) ? columnValue : handler(columnValue);
    }

    public static void main(String[] args) {
        NameDesensitizationHandler nameDesensitizationHandler = new NameDesensitizationHandler();
        System.out.println(nameDesensitizationHandler.handler("张三四"));
    }
    
}
