package top.doudou.mybatis.plus.encrypt.interceptor;

import top.doudou.mybatis.plus.encrypt.DefKeyCenterUtil;
import top.doudou.mybatis.plus.encrypt.KeyCenterUtil;

import java.lang.annotation.*;

/**
 * 属性加密语解密
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface EncryptAndDecryptField {

    /**
     * 加密的密钥
     * @return
     */
    String encryptKey() default "";

    /**
     * 解密的密钥
     * @return
     */
    String decryptKey() default "";

    /**
     * 加解密算法
     * @return
     */
    Class<? extends KeyCenterUtil> keyCenterUtil() default DefKeyCenterUtil.class;
}