package top.doudou.mybatis.plus.tenant;

import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import top.doudou.core.exception.ExceptionUtils;
import top.doudou.mybatis.plus.context.TenantContextHolder;
import top.doudou.mybatis.plus.tenant.annotation.CancelTenant;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Description sql解析器，提供CancelTenant注解的支持
 * @author 傻男人<244191347@qq.com>
 * @Date 2020-09-24 9:38
 * @Version V1.0
 */
@Slf4j
public class SqlParserFilter implements ISqlParserFilter {

    Map<String,Optional<CancelTenant>> cacheCancelTenant = new ConcurrentHashMap<>();


    @Override
    public boolean doFilter(MetaObject metaObject) {
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");

        //线程上下文决定决定是否强制过滤
        boolean result =  TenantContextHolder.getOp().map(v ->v.isFilter()).orElse(false);

        if(result){
            return true;
        }

        //CancelTenant 决定是否解析sql
        Optional<CancelTenant> cancelTenant = getCancelTenant(ms.getId());

        Boolean flag = cancelTenant.map(v -> v.value()).orElse(false);
        log.info("租户解析的信息为:"+flag);
        return flag;
    }



    protected Optional<CancelTenant>  getCancelTenant(String msId){

        if(cacheCancelTenant.containsKey(msId)){
            return cacheCancelTenant.get(msId) ;
        }

        Optional<CancelTenant> cached = msIdToCancelTenant(msId);
        cacheCancelTenant.put(msId,cached);


        return  cached;
    }




    protected Optional<CancelTenant> msIdToCancelTenant(String msId)  {

        int lastSplit = msId.lastIndexOf(".");
        String className = msId.substring(0,lastSplit);
        String methodName =  msId.substring(lastSplit+1);

        Class cls = null;
        Optional<CancelTenant> tenant = Optional.empty();
        //检查类中方法注解
        try {
            cls = Class.forName(className);

            CancelTenant tenant1 = Arrays.stream(cls.getMethods()).filter(method ->{
                return method.getName().equals(methodName);
            }).findFirst().get().getAnnotation(CancelTenant.class);
            tenant  = Optional.ofNullable(tenant1);
        } catch (Exception e) {
            //do nothing
        }

        //检查类注解
        if(!tenant.isPresent()){
            try {
                CancelTenant tenant2 = (CancelTenant) cls.getAnnotation(CancelTenant.class);
                tenant  = Optional.ofNullable(tenant2);
            } catch (Exception e) {
                log.error(ExceptionUtils.toString(e));
            }
        }

        return  tenant;
    }
}
