package top.doudou.mybatis.plus.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.collections.CollectionUtils;
import top.doudou.core.util.ListUtils;

import java.util.List;

/**
 * @Description IPage工具类
 * @author 傻男人<244191347@qq.com>
 * @Date 2021-02-01 10:33
 * @Version V1.0
 */
public class IPageUtil {

    public static <T> IPage<T> create(IPage page, Class<T> target){
        IPage<T> result = new Page<>();
        List records = page.getRecords();
        if(CollectionUtils.isNotEmpty(records)){
            result.setRecords(ListUtils.copyList(records,target));
        }
        result.setTotal(page.getTotal());
        result.setSize(page.getSize());
        result.setCurrent(page.getCurrent());
        result.setPages(page.getPages());
        return result;
    }
}