package top.doudou.mybatis.plus.config;

import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import lombok.extern.slf4j.Slf4j;
import top.doudou.base.util.IpHelper;


/**
 * @Description 自定义mybatis中id生成器
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2022-02-24 9:55
 * @Version V1.0
 */
@Slf4j
public class CustomIdentifierGenerator implements IdentifierGenerator {

    private final Sequence sequence;

    private Long workerId;

    private Long dataCenterId;

    private String serverIP;

    private String applicationName;

    public CustomIdentifierGenerator(long workerId, long dataCenterId) {
        this.serverIP = IpHelper.getLocalIp();
        this.sequence = new Sequence(workerId, dataCenterId);
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        log.info("-----> applicationName:{},serverIP:{},workerId:{},dataCenterId:{}",applicationName,serverIP,workerId,dataCenterId);
    }

    public CustomIdentifierGenerator(String applicationName, long workerId, long dataCenterId) {
        this.serverIP = IpHelper.getLocalIp();
        this.sequence = new Sequence(workerId, dataCenterId);
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.applicationName = applicationName;
        log.info("-----> applicationName:{},serverIP:{},workerId:{},dataCenterId:{}",applicationName,serverIP,workerId,dataCenterId);
    }

    public CustomIdentifierGenerator(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public Long nextId(Object entity) {
//        log.info("执行自定义的id生成器  applicationName:{},serverIP:{},workerId:{},dataCenterId:{}",applicationName,serverIP,workerId,dataCenterId);
        return sequence.nextId();
    }

    public Long nextId() {
//        log.info("执行自定义的id生成器  applicationName:{},serverIP:{},workerId:{},dataCenterId:{}",applicationName,serverIP,workerId,dataCenterId);
        return sequence.nextId();
    }
}