package top.doudou.mybatis.plus.encrypt;

import lombok.extern.slf4j.Slf4j;

import java.util.Base64;

/**
 * @Description 默认使用Base64加密逻辑
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-11 20:00
 */
@Slf4j
public class DefKeyCenterUtil implements KeyCenterUtil {

    /**
     * 加密逻辑
     * @param source
     * @param encryptKey  加密key
     * @return
     */
    public  String encrypt(String source,String encryptKey) {
        try {
            return Base64.getEncoder().encodeToString(source.getBytes("UTF-8"));
        } catch (Exception e) {
            log.info("[DefKeyCenterUtil]   加密失败    source:{}",source);
        }
        return source;
    }

    /**
     * 解密逻辑
     * @param source
     * @param decryptKey  解密key
     * @return
     */
    public  String decrypt(String source,String decryptKey) {
        try {
            return new String(Base64.getDecoder().decode(source), "UTF-8");
        } catch (Exception e) {
            log.info("[DefKeyCenterUtil]   解密失败    source:{}",source);
        }
        return source;
    }

}
