package top.doudou.mybatis.plus.encrypt.handle;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.springframework.beans.factory.annotation.Autowired;
import top.doudou.mybatis.plus.encrypt.KeyCenterUtil;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @Description 字段加解密算法
 * 需要在实体上添加@TableName(autoResultMap = true)
 * 加密的字段上添加 @TableField(typeHandler = CustomTypeHandler.class)
 * @author 傻男人<244191347@qq.com>
 * @Date 2021-01-11 11:19
 * @Version V1.0
 */
@Slf4j
public class EncryptTypeHandler<T> extends BaseTypeHandler<T> {

    private KeyCenterUtil keyCenterUtil;

    @Autowired
    public void setKeyCenterUtil(KeyCenterUtil keyCenterUtil) {
        this.keyCenterUtil = keyCenterUtil;
    }

    public EncryptTypeHandler(){}

    /**
     * 向PreparedStatement里面设置值
     * @param ps
     * @param i
     * @param parameter
     * @param jdbcType
     * @throws SQLException
     */
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        log.info(" ------------------->     setNonNullParameter   parameter:{}   jdbcType:{}",parameter,jdbcType);
        ps.setString(i, this.keyCenterUtil.encrypt((String)parameter,null));
    }

    /**
     * 根据列名获取值
     * @param rs
     * @param columnName
     * @return
     * @throws SQLException
     */
    @Override
    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String columnValue = rs.getString(columnName);
        return StringUtils.isBlank(columnValue) ? (T)columnValue : (T)this.keyCenterUtil.decrypt(columnValue,null);
    }

    /**
     * 根据列索引位置获取值
     * @param rs
     * @param columnIndex
     * @return
     * @throws SQLException
     */
    @Override
    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String columnValue = rs.getString(columnIndex);
        return StringUtils.isBlank(columnValue) ? (T)columnValue : (T)this.keyCenterUtil.decrypt(columnValue,null);
    }

    /**
     * 存储过程
     * @param cs
     * @param columnIndex
     * @return
     * @throws SQLException
     */
    @Override
    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String columnValue = cs.getString(columnIndex);
        return StringUtils.isBlank(columnValue) ? (T)columnValue : (T)this.keyCenterUtil.decrypt(columnValue,null);
    }
}