package top.doudou.mybatis.plus.interceptor;

import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import top.doudou.mybatis.plus.utils.MyBatisUtils;
import top.doudou.mybatis.plus.utils.ResultSetUtil;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;

/**
 * @Description
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-02-23 14:41
 */
//@Component
@Intercepts({
        @Signature(type = StatementHandler.class,method = "prepare",args = {Connection.class, Integer.class})
})
@Slf4j
public class MybatisPreInterceptor implements Interceptor {
    @Override
    public Object intercept(Invocation invocation) throws Throwable {

        log.info("----------->  进入预处理插件   ");
        Object realStatement = MyBatisUtils.getNoProxyTarget(invocation.getTarget());
        Object statement = invocation.getArgs()[0];
        log.info(" ---->   realStatement：{}     statement:{}",realStatement.getClass(),statement.getClass());
        String sql = "select count(*) from system_user ";
        ResultSet resultSet = MyBatisUtils.executeSql(invocation, (StatementHandler) realStatement, sql);
        String s = ResultSetUtil.onlyOneResult(resultSet, String.class);

        String sql1 = "select user_name from system_user ";
        ResultSet resultSet1 = MyBatisUtils.executeSql(invocation, (StatementHandler) realStatement, sql1);
        List<String> result = ResultSetUtil.onlyOneListResult(resultSet, String.class);
        return invocation.proceed();
    }
}
