package top.doudou.mybatis.plus.mapper;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;


/**
 * @Description  悲观锁的方式通过id查询
 * @author 傻男人<244191347@qq.com>
 * @Date 2020-09-23 17:10
 * @Version V1.0
 */
public class GloomyLockFindById extends AbstractMethod {
    @Override
    public MappedStatement injectMappedStatement(Class<?> mapperClass,
                                                 Class<?> modelClass, TableInfo tableInfo) {

        String sql = "select * FROM "+ tableInfo.getTableName()+" where id = #{id}   for UPDATE";
        String method = "gloomyLockFindById";
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        return addSelectMappedStatementForTable(mapperClass,method, sqlSource,tableInfo);
    }


}