package top.doudou.mybatis.plus;

import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import top.doudou.core.exception.CustomException;
import top.doudou.core.exception.ExceptionUtils;

import javax.sql.DataSource;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * @Description
 * @author 傻男人<244191347@qq.com>
 * @Date 2020-10-27 11:19
 * @Version V1.0
 */
@Slf4j
public class MyApplicationStartedListener implements ApplicationListener<ApplicationStartedEvent> {
    @Override
    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        DataSource dataSource = applicationContext.getBean(DataSource.class);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        } catch (SQLException e) {
            log.error(ExceptionUtils.toString(e));
            throw new CustomException("获取数据库的连接异常",e);
        }
        ScriptRunner runner=new ScriptRunner(connection);
        try {
            Reader resourceAsReader = Resources.getResourceAsReader("schema_data.sql");
            runner.runScript(resourceAsReader);
        } catch (IOException e) {
            log.error(ExceptionUtils.toString(e));
        }
    }
}
