package top.doudou.mybatis.plus.config;

import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.doudou.core.constant.SystemHolder;
import top.doudou.mybatis.plus.encrypt.DefKeyCenterUtil;
import top.doudou.mybatis.plus.encrypt.KeyCenterUtil;

/**
 * @Description
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-03-30 17:24
 */
@Slf4j
@Configuration
public class InitialConfig {

    /**
     * 字段自定义加密
     * @return
     */
    @Bean("keyCenterUtil")
    @ConditionalOnMissingBean(name = "keyCenterUtil")
    public KeyCenterUtil keyCenterUtil(){
        return new DefKeyCenterUtil();
    }

    /**
     * 自定义id生成器
     * @return
     */
    @Bean
    @ConditionalOnProperty(name = "mybatis.custom.id.enabled",havingValue = "true",matchIfMissing = false)
    public IdentifierGenerator identifierGenerator() {
        Long workerId = Long.valueOf(RandomUtil.randomInt(0,31));
        Long dataCenterId = Long.valueOf(RandomUtil.randomInt(0,31));
        return new CustomIdentifierGenerator(SystemHolder.applicationName,workerId,dataCenterId);
    }
}
