package top.doudou.mybatis.plus.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description sql结果集日志
 * @author 傻男人<244191347@qq.com>
 * @Date 2020-11-19 10:56
 * @Version V1.0
 */
@Data
@ApiModel("sql结果集日志")
public class SqlResultDto implements Serializable {

    @ApiModelProperty("表头")
    private String header;

    @ApiModelProperty("数据")
    private List<String> columnList;

    public SqlResultDto(){}

    public SqlResultDto(String header,List<String> columnList) {
        this.header = header;
        this.columnList = columnList;
    }

    public void setHeader(String header){
        this.header = header;
    }

    public void setColumnList(List<String> columnList){
        this.columnList = columnList;
    }

    public synchronized void setColumnList(String column){
        if(CollectionUtils.isEmpty(this.columnList)){
            List<String> list = new ArrayList<>();
            list.add(column);
            setColumnList(list);
        }else {
            this.columnList.add(column);
        }
    }
}
