package top.doudou.mybatis.plus.search;


import org.apache.commons.lang3.StringUtils;

/**
 * @Description Query 规则 常量
 * @author 傻男人<244191347@qq.com>
 * @Date 2022-03-10
 * @Version V1.0
 */
public enum QueryRuleEnum {

    GT(">","大于"),
    GE(">=","大于等于"),
    LT("<","小于"),
    LE("<=","小于等于"),
    EQ("=","等于"),
    NE("!=","不等于"),
    IN("IN","包含"),
    LIKE("LIKE","全模糊"),
    LEFT_LIKE("LEFT_LIKE","左模糊"),
    RIGHT_LIKE("RIGHT_LIKE","右模糊"),
    IS_NULL("IS_NULL","为空"),
    IS_NOT_NULL("IS_NOT_NULL","不为空"),
    SQL_RULES("EXTEND_SQL","自定义SQL片段");

    private String value;

    private String msg;

    QueryRuleEnum(String value, String msg){
        this.value = value;
        this.msg = msg;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static QueryRuleEnum getByValue(String value){
    	if(StringUtils.isEmpty(value)) {
    		return null;
    	}
        for(QueryRuleEnum val :values()){
            if (val.getValue().equals(value)){
                return val;
            }
        }
        return  null;
    }
}
