package top.doudou.mybatis.plus.utils;

import lombok.extern.slf4j.Slf4j;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description ResultSet工具类
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-02-23 13:33
 */
@Slf4j
public class ResultSetUtil {

    public Object getResult(ResultSet rs) throws SQLException {
        while (rs.next()){
            int id=rs.getInt("id");
            String name=rs.getString("name");
            int uid=rs.getInt("uid");
            long time=rs.getLong("add_time");
            System.out.println("编号："+id+",名称："+name+",会员id："+uid+",添加时间："+time);
        }
        return null;
    }

    /**
     * 只是查询一个结果集，比如查询表的总数，假如数据是多条,只是取第一条的数据
     * @param rs
     * @return
     * @throws SQLException
     */
    public static <T>T onlyOneResult(ResultSet rs,Class<T> target) throws SQLException {
        while (rs.next()){
            return (T)rs.getObject(1);
        }
        return null;
    }

    /**
     * 获取结果集中单一字段的list值，比如查询结果为多条的单字段值
     * @param rs
     * @param target
     * @param <T>
     * @return
     * @throws SQLException
     */
    public static <T>List<T> onlyOneListResult(ResultSet rs,Class<T> target) throws SQLException {
        List<T> list = new ArrayList<>();
        while (rs.next()){
            list.add((T)rs.getObject(1));
        }
        return list;
    }
}
