/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.config;

import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.util.IpHelper;

public class CustomIdentifierGenerator
implements IdentifierGenerator {
    private static final Logger log = LoggerFactory.getLogger(CustomIdentifierGenerator.class);
    private final Sequence sequence;
    private Long workerId;
    private Long dataCenterId;
    private String serverIP;
    private String applicationName;

    public CustomIdentifierGenerator(long workerId, long dataCenterId) {
        this.serverIP = IpHelper.getLocalIp();
        this.sequence = new Sequence(workerId, dataCenterId);
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        log.info("-----> applicationName:{},serverIP:{},workerId:{},dataCenterId:{}", new Object[]{this.applicationName, this.serverIP, workerId, dataCenterId});
    }

    public CustomIdentifierGenerator(String applicationName, long workerId, long dataCenterId) {
        this.serverIP = IpHelper.getLocalIp();
        this.sequence = new Sequence(workerId, dataCenterId);
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.applicationName = applicationName;
        log.info("-----> applicationName:{},serverIP:{},workerId:{},dataCenterId:{}", new Object[]{applicationName, this.serverIP, workerId, dataCenterId});
    }

    public CustomIdentifierGenerator(Sequence sequence) {
        this.sequence = sequence;
    }

    public Long nextId(Object entity) {
        return this.sequence.nextId();
    }

    public Long nextId() {
        return this.sequence.nextId();
    }
}

