/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.config;

import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.doudou.core.constant.SystemHolder;
import top.doudou.mybatis.plus.config.CustomIdentifierGenerator;
import top.doudou.mybatis.plus.encrypt.DefKeyCenterUtil;
import top.doudou.mybatis.plus.encrypt.KeyCenterUtil;

@Configuration
public class InitialConfig {
    private static final Logger log = LoggerFactory.getLogger(InitialConfig.class);

    @Bean(value={"keyCenterUtil"})
    @ConditionalOnMissingBean(name={"keyCenterUtil"})
    public KeyCenterUtil keyCenterUtil() {
        return new DefKeyCenterUtil();
    }

    @Bean
    @ConditionalOnProperty(name={"mybatis.custom.id.enabled"}, havingValue="true", matchIfMissing=false)
    public IdentifierGenerator identifierGenerator() {
        Long workerId = RandomUtil.randomInt((int)0, (int)31);
        Long dataCenterId = RandomUtil.randomInt((int)0, (int)31);
        return new CustomIdentifierGenerator(SystemHolder.applicationName, workerId, dataCenterId);
    }
}

