/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.extension.parsers.BlockAttackSqlParser;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.SqlExplainInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import top.doudou.mybatis.plus.context.TenantContextHolder;

@Configuration
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setDialectType(DbType.MYSQL.getDb());
        paginationInterceptor.setOverflow(false);
        paginationInterceptor.setLimit(500L);
        paginationInterceptor.setCountSqlParser((ISqlParser)new JsqlParserCountOptimize(true));
        ArrayList<BlockAttackSqlParser> sqlParserList = new ArrayList<BlockAttackSqlParser>();
        sqlParserList.add(new BlockAttackSqlParser());
        paginationInterceptor.setSqlParserList(sqlParserList);
        return paginationInterceptor;
    }

    @Bean
    @Profile(value={"dev", "test"})
    public SqlExplainInterceptor sqlExplainInterceptor() {
        SqlExplainInterceptor sqlExplainInterceptor = new SqlExplainInterceptor();
        return sqlExplainInterceptor;
    }

    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }

    private TenantSqlParser tenantSqlParser() {
        TenantSqlParser tenantSqlParser = new TenantSqlParser();
        tenantSqlParser.setTenantHandler(new TenantHandler(){

            public Expression getTenantId(boolean select) {
                Long tenantId = TenantContextHolder.getTenantId();
                log.info("tenantId:" + tenantId);
                return new LongValue(tenantId.longValue());
            }

            public String getTenantIdColumn() {
                return "tenant_id";
            }

            public boolean doTableFilter(String tableName) {
                return false;
            }
        });
        return tenantSqlParser;
    }

    private TenantSqlParser organizationSqlParser() {
        TenantSqlParser tenantSqlParser = new TenantSqlParser();
        tenantSqlParser.setTenantHandler(new TenantHandler(){

            public Expression getTenantId(boolean select) {
                log.info("-------------select-----------:" + select);
                return new LongValue(TenantContextHolder.getOrganizationId().longValue());
            }

            public String getTenantIdColumn() {
                return "organization_id";
            }

            public boolean doTableFilter(String tableName) {
                return false;
            }
        });
        return tenantSqlParser;
    }
}

