/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.encrypt.handle;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import top.doudou.mybatis.plus.encrypt.KeyCenterUtil;

public class EncryptTypeHandler<T>
extends BaseTypeHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(EncryptTypeHandler.class);
    private KeyCenterUtil keyCenterUtil;

    @Autowired
    public void setKeyCenterUtil(KeyCenterUtil keyCenterUtil) {
        this.keyCenterUtil = keyCenterUtil;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        log.info(" ------------------->     setNonNullParameter   parameter:{}   jdbcType:{}", parameter, (Object)jdbcType);
        ps.setString(i, this.keyCenterUtil.encrypt((String)parameter, null));
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String columnValue = rs.getString(columnName);
        return (T)(StringUtils.isBlank((CharSequence)columnValue) ? columnValue : this.keyCenterUtil.decrypt(columnValue, null));
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String columnValue = rs.getString(columnIndex);
        return (T)(StringUtils.isBlank((CharSequence)columnValue) ? columnValue : this.keyCenterUtil.decrypt(columnValue, null));
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String columnValue = cs.getString(columnIndex);
        return (T)(StringUtils.isBlank((CharSequence)columnValue) ? columnValue : this.keyCenterUtil.decrypt(columnValue, null));
    }
}

