/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.encrypt.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperProxyFactory;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;
import top.doudou.core.exception.CustomException;
import top.doudou.mybatis.plus.encrypt.KeyCenterUtil;
import top.doudou.mybatis.plus.encrypt.interceptor.DecryptField;
import top.doudou.mybatis.plus.encrypt.interceptor.EncryptAndDecryptField;
import top.doudou.mybatis.plus.encrypt.interceptor.EncryptField;

@Component
@ConditionalOnClass(value={MapperProxyFactory.class})
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisEncryptAndDecryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisEncryptAndDecryptInterceptor.class);
    public static final String UPDATE = "update";

    public Object intercept(Invocation invocation) throws Throwable {
        boolean next = true;
        String methodName = invocation.getMethod().getName();
        Object parameter = invocation.getArgs()[1];
        if (UPDATE.equalsIgnoreCase(methodName)) {
            next = false;
            this.encryptField(parameter);
        }
        Object returnValue = invocation.proceed();
        if (next) {
            try {
                if (returnValue instanceof ArrayList) {
                    List list = (List)returnValue;
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        return returnValue;
                    }
                    list.forEach(item -> {
                        this.decryptField(item);
                        this.sensitiveHandler(item);
                    });
                }
            }
            catch (Exception e) {
                log.info("\u89e3\u5bc6\u51fa\u9519  error message:{}", (Object)e.getMessage());
                return returnValue;
            }
        }
        return returnValue;
    }

    private void sensitiveHandler(Object item) {
    }

    public Object plugin(Object target) {
        return super.plugin(target);
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
    }

    public <T> void decryptField(T t) {
        Field[] declaredFields = t.getClass().getDeclaredFields();
        Arrays.stream(declaredFields).forEach(field -> {
            if ((field.isAnnotationPresent(DecryptField.class) || field.isAnnotationPresent(EncryptAndDecryptField.class)) && field.getType().equals(String.class)) {
                Annotation annotation;
                String value = null;
                KeyCenterUtil keyCenterUtil = null;
                if (field.isAnnotationPresent(DecryptField.class)) {
                    annotation = field.getAnnotation(DecryptField.class);
                    value = annotation.value();
                    keyCenterUtil = this.newInstance(annotation.keyCenterUtil());
                } else {
                    annotation = field.getAnnotation(EncryptAndDecryptField.class);
                    value = annotation.decryptKey();
                    keyCenterUtil = this.newInstance(annotation.keyCenterUtil());
                }
                field.setAccessible(true);
                try {
                    String fieldValue = (String)field.get(t);
                    if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
                        field.set(t, keyCenterUtil.decrypt(fieldValue, value));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public <T> void encryptField(T t) {
        Field[] declaredFields = t.getClass().getDeclaredFields();
        Arrays.stream(declaredFields).forEach(field -> {
            if ((field.isAnnotationPresent(EncryptField.class) || field.isAnnotationPresent(EncryptAndDecryptField.class)) && field.getType().equals(String.class)) {
                Annotation annotation;
                String value = null;
                KeyCenterUtil keyCenterUtil = null;
                if (field.isAnnotationPresent(EncryptField.class)) {
                    annotation = field.getAnnotation(EncryptField.class);
                    value = annotation.value();
                    keyCenterUtil = this.newInstance(annotation.keyCenterUtil());
                } else {
                    annotation = field.getAnnotation(EncryptAndDecryptField.class);
                    value = annotation.encryptKey();
                    keyCenterUtil = this.newInstance(annotation.keyCenterUtil());
                }
                field.setAccessible(true);
                try {
                    String fieldValue = (String)field.get(t);
                    if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
                        field.set(t, keyCenterUtil.encrypt(fieldValue, value));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private <T> T newInstance(Class<T> target) {
        try {
            return target.newInstance();
        }
        catch (Exception e) {
            log.error("target\uff1a{} \u53cd\u5c04\u51fa\u73b0\u9519\u8bef,\u9519\u8bef\u7684\u539f\u56e0\uff1a{}", (Object)target.getClass().getName(), (Object)e.getMessage());
            throw new CustomException((Throwable)e);
        }
    }
}

