/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.entity;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import top.doudou.mybatis.plus.entity.SqlResultDto;

public class SqlLogDto
implements Serializable {
    private static final ThreadLocal<SqlLogDto> SQL_DATE = new InheritableThreadLocal<SqlLogDto>();
    private Long cost;
    private String sqlId;
    private String shortSqlId;
    private String sentence;
    private String requestId;
    private Integer rows;
    private Object result;
    private SqlResultDto formatSqlRetDto;

    private SqlLogDto() {
    }

    public static void setCurrent(SqlLogDto data) {
        SQL_DATE.set(data);
    }

    public static void removeCurrent() {
        SQL_DATE.remove();
    }

    public static SqlLogDto getCurrent() {
        SqlLogDto data = SQL_DATE.get();
        if (data == null) {
            data = new SqlLogDto();
            SQL_DATE.set(data);
        }
        return SQL_DATE.get();
    }

    public static void setCurFormatSqlRetDto(SqlResultDto formatSqlRetDto) {
        SqlLogDto.getCurrent().setFormatSqlRetDto(formatSqlRetDto);
    }

    public static void setCurSentence(String sentence) {
        if (StringUtils.isNotBlank((CharSequence)sentence)) {
            sentence = sentence + ";";
        }
        SqlLogDto.getCurrent().setSentence(sentence);
    }

    public static void setCurCost(Long cost) {
        SqlLogDto.getCurrent().setCost(cost);
    }

    public static void setCurRows(Integer rows) {
        SqlLogDto.getCurrent().setRows(rows);
    }

    public static void setCurResult(Object result) {
        SqlLogDto.getCurrent().setResult(result);
    }

    public static void setCurRequestId(String requestId) {
        SqlLogDto.getCurrent().setRequestId(requestId);
    }

    public static void setCurSqlId(String sqlId) {
        SqlLogDto.getCurrent().setSqlId(sqlId);
        if (StringUtils.isBlank((CharSequence)sqlId)) {
            return;
        }
        String[] split = sqlId.split("\\.");
        int length = split.length;
        String shortSqlId = length >= 2 ? split[length - 2] + "." + split[length - 1] : sqlId;
        SqlLogDto.getCurrent().setShortSqlId(shortSqlId);
    }

    public String toString() {
        Object rtn;
        Integer rows;
        String sentence;
        String shortSqlId;
        Long cost;
        StringBuilder result = new StringBuilder();
        String requestId = this.getRequestId();
        if (StringUtils.isNotEmpty((CharSequence)requestId)) {
            result.append(result.length() == 0 ? requestId : "    " + requestId);
        }
        if (null != (cost = this.getCost())) {
            result.append(result.length() == 0 ? cost : "    " + cost);
        }
        if (StringUtils.isNotEmpty((CharSequence)(shortSqlId = this.getShortSqlId()))) {
            result.append(result.length() == 0 ? shortSqlId : "    " + shortSqlId);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sentence = this.getSentence()))) {
            result.append(result.length() == 0 ? sentence : "    " + sentence);
        }
        if (null != (rows = this.getRows())) {
            result.append(result.length() == 0 ? rows : "    " + rows);
        }
        if (null != this.getFormatSqlRetDto()) {
            result.append(this.getFormatSqlRetDto());
        }
        if (null != (rtn = this.getResult())) {
            result.append(result.length() == 0 ? rtn : "    " + rtn);
        }
        return result.toString();
    }

    public Long getCost() {
        return this.cost;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public String getShortSqlId() {
        return this.shortSqlId;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Integer getRows() {
        return this.rows;
    }

    public Object getResult() {
        return this.result;
    }

    public SqlResultDto getFormatSqlRetDto() {
        return this.formatSqlRetDto;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public void setSqlId(String sqlId) {
        this.sqlId = sqlId;
    }

    public void setShortSqlId(String shortSqlId) {
        this.shortSqlId = shortSqlId;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setFormatSqlRetDto(SqlResultDto formatSqlRetDto) {
        this.formatSqlRetDto = formatSqlRetDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlLogDto)) {
            return false;
        }
        SqlLogDto other = (SqlLogDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$cost = this.getCost();
        Long other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        Integer this$rows = this.getRows();
        Integer other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        String this$sqlId = this.getSqlId();
        String other$sqlId = other.getSqlId();
        if (this$sqlId == null ? other$sqlId != null : !this$sqlId.equals(other$sqlId)) {
            return false;
        }
        String this$shortSqlId = this.getShortSqlId();
        String other$shortSqlId = other.getShortSqlId();
        if (this$shortSqlId == null ? other$shortSqlId != null : !this$shortSqlId.equals(other$shortSqlId)) {
            return false;
        }
        String this$sentence = this.getSentence();
        String other$sentence = other.getSentence();
        if (this$sentence == null ? other$sentence != null : !this$sentence.equals(other$sentence)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        Object this$result = this.getResult();
        Object other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        SqlResultDto this$formatSqlRetDto = this.getFormatSqlRetDto();
        SqlResultDto other$formatSqlRetDto = other.getFormatSqlRetDto();
        return !(this$formatSqlRetDto == null ? other$formatSqlRetDto != null : !((Object)this$formatSqlRetDto).equals(other$formatSqlRetDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlLogDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        Integer $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        String $sqlId = this.getSqlId();
        result = result * 59 + ($sqlId == null ? 43 : $sqlId.hashCode());
        String $shortSqlId = this.getShortSqlId();
        result = result * 59 + ($shortSqlId == null ? 43 : $shortSqlId.hashCode());
        String $sentence = this.getSentence();
        result = result * 59 + ($sentence == null ? 43 : $sentence.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        Object $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        SqlResultDto $formatSqlRetDto = this.getFormatSqlRetDto();
        result = result * 59 + ($formatSqlRetDto == null ? 43 : ((Object)$formatSqlRetDto).hashCode());
        return result;
    }
}

