/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.mybatis.plus.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public class MyBatisUtils {
    public static Object getNoProxyTarget(Object target) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        while (metaObject.hasGetter("h")) {
            target = metaObject.getValue("h.target");
            metaObject = SystemMetaObject.forObject((Object)target);
        }
        return target;
    }

    public static void changeExecuteSql(StatementHandler statementHandler, String sql) {
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject((Object)boundSql);
        metaObject.setValue("sql", (Object)sql);
    }

    public static int getFromIndex(int beginIndex, String sql) {
        int fromIndex = sql.indexOf("from", beginIndex);
        if (fromIndex == -1) {
            return -1;
        }
        int count = 0;
        int selectIndex = fromIndex;
        int bIndex = -1;
        while ((bIndex = sql.lastIndexOf("(", selectIndex)) != -1) {
            ++count;
            selectIndex = bIndex - 1;
        }
        selectIndex = fromIndex;
        int eIndex = -1;
        while ((eIndex = sql.lastIndexOf(")", selectIndex)) != -1) {
            --count;
            selectIndex = eIndex - 1;
        }
        if (count == 0) {
            return fromIndex;
        }
        return MyBatisUtils.getFromIndex(fromIndex + 1, sql);
    }

    public static String getSqlTotal(String sql) {
        int index = MyBatisUtils.getFromIndex(0, sql);
        return "select count(*) as total " + sql.substring(index);
    }

    public static ResultSet executeSql(Invocation invocation, StatementHandler statementHandler, String sql) throws SQLException {
        Connection connection = (Connection)invocation.getArgs()[0];
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            ps = connection.prepareStatement(sql);
            statementHandler.parameterize((Statement)ps);
            ResultSet resultSet2 = resultSet = ps.executeQuery();
            return resultSet2;
        }
        catch (SQLException throwables) {
            throw throwables;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }
}

