/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms.client;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import top.doudou.common.sms.properties.ALiYunProperties;
import top.doudou.common.tool.exception.ConnectionException;
import top.doudou.common.tool.exception.CustomException;
import top.doudou.common.tool.exception.InvalidException;

public class AliClientClient {
    private ALiYunProperties aLiYunProperties;

    public AliClientClient() {
    }

    public AliClientClient(ALiYunProperties properties) {
        this.aLiYunProperties = properties;
    }

    public void setALiYunProperties(ALiYunProperties properties) {
        this.aLiYunProperties = properties;
    }

    protected CommonRequest createCommonRequest(String smsType) {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction(smsType);
        request.putQueryParameter("RegionId", this.aLiYunProperties.getRegionId());
        return request;
    }

    protected IAcsClient createClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.aLiYunProperties.getRegionId(), (String)this.aLiYunProperties.getAccessKeyId(), (String)this.aLiYunProperties.getAccessSecret());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    protected <T> T callAliCloud(CommonRequest request, Class<T> target) {
        IAcsClient client = this.createClient();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE);
        Gson gson = gsonBuilder.create();
        try {
            CommonResponse response = client.getCommonResponse(request);
            System.out.println(response.getData());
            Object t = gson.fromJson(response.getData(), target);
            if (!"OK".equals(this.getMethodValue(t, "getCode"))) {
                throw new ConnectionException(this.getMethodValue(t, "getMessage"));
            }
            return (T)t;
        }
        catch (ServerException e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new ConnectionException(e.getMessage());
        }
    }

    private <T> String getMethodValue(T t, String methodName) {
        try {
            Method method = t.getClass().getMethod(methodName, new Class[0]);
            String code = (String)method.invoke(t, null);
            return code;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InvalidException("\u672a\u627e\u5230\u8be5\u65b9\u6cd5\uff1a" + methodName);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InvalidException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new InvalidException(e.getMessage());
        }
    }

    public ALiYunProperties getALiYunProperties() {
        return this.aLiYunProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AliClientClient)) {
            return false;
        }
        AliClientClient other = (AliClientClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ALiYunProperties this$aLiYunProperties = this.getALiYunProperties();
        ALiYunProperties other$aLiYunProperties = other.getALiYunProperties();
        return !(this$aLiYunProperties == null ? other$aLiYunProperties != null : !((Object)this$aLiYunProperties).equals(other$aLiYunProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AliClientClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ALiYunProperties $aLiYunProperties = this.getALiYunProperties();
        result = result * 59 + ($aLiYunProperties == null ? 43 : ((Object)$aLiYunProperties).hashCode());
        return result;
    }

    public String toString() {
        return "AliClientClient(aLiYunProperties=" + this.getALiYunProperties() + ")";
    }
}

