/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms.client;

import com.aliyuncs.CommonRequest;
import com.google.gson.Gson;
import top.doudou.common.sms.client.AliClientClient;
import top.doudou.common.sms.entity.QuerySendDetailDto;
import top.doudou.common.sms.entity.SendSmsDto;
import top.doudou.common.sms.entity.back.send.QuerySendDetailReturnDto;
import top.doudou.common.sms.entity.back.send.SendSmsReturnDto;
import top.doudou.common.sms.properties.ALiYunProperties;

public class SmsSendClient {
    private ALiYunProperties properties;

    public SmsSendClient(ALiYunProperties properties) {
        this.properties = properties;
    }

    public SendSmsReturnDto sendSms(SendSmsDto sendSmsDto) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("SendSms");
        request.putQueryParameter("PhoneNumbers", sendSmsDto.getPhone());
        request.putQueryParameter("SignName", sendSmsDto.getSignName());
        request.putQueryParameter("TemplateCode", sendSmsDto.getTemplateCode());
        Gson gson = new Gson();
        request.putQueryParameter("TemplateParam", gson.toJson(sendSmsDto.getTemplateParam()));
        return aliClientClient.callAliCloud(request, SendSmsReturnDto.class);
    }

    public QuerySendDetailReturnDto querySendDetails(QuerySendDetailDto querySendDetailDto) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("QuerySendDetails");
        request.putQueryParameter("PhoneNumber", querySendDetailDto.getPhone());
        request.putQueryParameter("SendDate", querySendDetailDto.getSendDate());
        request.putQueryParameter("PageSize", String.valueOf(querySendDetailDto.getPageSize()));
        request.putQueryParameter("CurrentPage", String.valueOf(querySendDetailDto.getCurrentPage()));
        return aliClientClient.callAliCloud(request, QuerySendDetailReturnDto.class);
    }
}

