/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms.client;

import com.aliyuncs.CommonRequest;
import java.io.Serializable;
import org.apache.commons.collections.CollectionUtils;
import top.doudou.common.sms.client.AliClientClient;
import top.doudou.common.sms.entity.SignFileDto;
import top.doudou.common.sms.entity.SmsSignEditDto;
import top.doudou.common.sms.entity.back.sign.QuerySignReturnDto;
import top.doudou.common.sms.entity.back.sign.SmsSignReturnDto;
import top.doudou.common.sms.properties.ALiYunProperties;

public class SmsSignClient
implements Serializable {
    private ALiYunProperties properties;

    public SmsSignClient(ALiYunProperties properties) {
        this.properties = properties;
    }

    public SmsSignReturnDto addSmsSign(SmsSignEditDto smsSignEditDto) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("AddSmsSign");
        request.putQueryParameter("SignName", smsSignEditDto.getSignName());
        request.putQueryParameter("SignSource", String.valueOf(smsSignEditDto.getSignSource()));
        request.putQueryParameter("Remark", smsSignEditDto.getRemark());
        if (CollectionUtils.isNotEmpty(smsSignEditDto.getSignFileList())) {
            int i = 1;
            for (SignFileDto signFileDto : smsSignEditDto.getSignFileList()) {
                request.putQueryParameter("SignFileList." + i + ".FileSuffix", signFileDto.getFileSuffix());
                request.putQueryParameter("SignFileList." + i + ".FileContents", signFileDto.getFileContents());
                ++i;
            }
        }
        return aliClientClient.callAliCloud(request, SmsSignReturnDto.class);
    }

    public SmsSignReturnDto deleteSmsSign(String signName) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("DeleteSmsSign");
        request.putQueryParameter("SignName", signName);
        return aliClientClient.callAliCloud(request, SmsSignReturnDto.class);
    }

    public SmsSignReturnDto modifySmsSign(SmsSignEditDto smsSignEditDto) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("ModifySmsSign");
        request.putQueryParameter("SignName", smsSignEditDto.getSignName());
        request.putQueryParameter("SignSource", String.valueOf(smsSignEditDto.getSignSource()));
        request.putQueryParameter("Remark", smsSignEditDto.getRemark());
        if (CollectionUtils.isNotEmpty(smsSignEditDto.getSignFileList())) {
            int i = 1;
            for (SignFileDto signFileDto : smsSignEditDto.getSignFileList()) {
                request.putQueryParameter("SignFileList." + i + ".FileSuffix", signFileDto.getFileSuffix());
                request.putQueryParameter("SignFileList." + i + ".FileContents", signFileDto.getFileContents());
                ++i;
            }
        }
        return aliClientClient.callAliCloud(request, SmsSignReturnDto.class);
    }

    public QuerySignReturnDto querySmsSign(String signName) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("QuerySmsSign");
        request.putQueryParameter("SignName", signName);
        return aliClientClient.callAliCloud(request, QuerySignReturnDto.class);
    }
}

