/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms.client;

import com.aliyuncs.CommonRequest;
import top.doudou.common.sms.client.AliClientClient;
import top.doudou.common.sms.entity.SmsTemplateAddDto;
import top.doudou.common.sms.entity.SmsTemplateUpdateDto;
import top.doudou.common.sms.entity.back.template.QueryTemplateReturnDto;
import top.doudou.common.sms.entity.back.template.SmsTemplateCodeReturnDto;
import top.doudou.common.sms.properties.ALiYunProperties;

public class SmsTemplateClient {
    private ALiYunProperties properties;

    public SmsTemplateClient(ALiYunProperties properties) {
        this.properties = properties;
    }

    public SmsTemplateCodeReturnDto addSmsTemplate(SmsTemplateAddDto smsTemplateAddDto) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("AddSmsTemplate");
        request.putQueryParameter("TemplateType", String.valueOf(smsTemplateAddDto.getTemplateType()));
        request.putQueryParameter("TemplateName", smsTemplateAddDto.getTemplateName());
        request.putQueryParameter("TemplateContent", smsTemplateAddDto.getTemplateContent());
        request.putQueryParameter("Remark", smsTemplateAddDto.getRemark());
        return aliClientClient.callAliCloud(request, SmsTemplateCodeReturnDto.class);
    }

    public SmsTemplateCodeReturnDto deleteSmsTemplate(String templateCode) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("DeleteSmsTemplate");
        request.putQueryParameter("TemplateCode", templateCode);
        return aliClientClient.callAliCloud(request, SmsTemplateCodeReturnDto.class);
    }

    public QueryTemplateReturnDto querySmsTemplate(String templateCode) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("QuerySmsTemplate");
        request.putQueryParameter("TemplateCode", templateCode);
        return aliClientClient.callAliCloud(request, QueryTemplateReturnDto.class);
    }

    public SmsTemplateCodeReturnDto modifySmsTemplate(SmsTemplateUpdateDto smsTemplateUpdateDto) {
        AliClientClient aliClientClient = new AliClientClient(this.properties);
        CommonRequest request = aliClientClient.createCommonRequest("ModifySmsTemplate");
        request.putQueryParameter("TemplateType", String.valueOf(smsTemplateUpdateDto.getTemplateType()));
        request.putQueryParameter("TemplateName", smsTemplateUpdateDto.getTemplateName());
        request.putQueryParameter("TemplateContent", smsTemplateUpdateDto.getTemplateContent());
        request.putQueryParameter("Remark", smsTemplateUpdateDto.getRemark());
        request.putQueryParameter("TemplateCode", smsTemplateUpdateDto.getTemplateCode());
        return aliClientClient.callAliCloud(request, SmsTemplateCodeReturnDto.class);
    }
}

