/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import top.doudou.common.sms.client.SmsSendClient;
import top.doudou.common.sms.client.SmsSignClient;
import top.doudou.common.sms.client.SmsTemplateClient;
import top.doudou.common.sms.properties.ALiYunProperties;
import top.doudou.common.tool.exception.InvalidException;

@Configuration
@ConditionalOnClass(value={ALiYunProperties.class})
@EnableConfigurationProperties(value={ALiYunProperties.class})
public class AliCloudEnableAutoConfiguration {
    @Autowired
    private ALiYunProperties properties;

    @Bean
    @Primary
    public SmsSendClient sendSmsClient() {
        this.checkALiYunProperties();
        return new SmsSendClient(this.properties);
    }

    @Bean
    @Primary
    public SmsTemplateClient smsTemplateClient() {
        this.checkALiYunProperties();
        return new SmsTemplateClient(this.properties);
    }

    @Bean
    @Primary
    public SmsSignClient smsSignClient() {
        this.checkALiYunProperties();
        return new SmsSignClient(this.properties);
    }

    private void checkALiYunProperties() {
        if (StringUtils.isBlank((CharSequence)this.properties.getRegionId())) {
            throw new InvalidException("not find properties aliyun.sms.regionId ");
        }
        if (StringUtils.isBlank((CharSequence)this.properties.getAccessKeyId())) {
            throw new InvalidException("not find properties aliyun.sms.accessKeyId ");
        }
        if (StringUtils.isBlank((CharSequence)this.properties.getAccessSecret())) {
            throw new InvalidException("not find properties aliyun.sms.accessSecret ");
        }
    }
}

