package top.doudou.swagger;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.List;

/**
 * @Description swagger的配置信息
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-14 15:06
 * @Version V1.0
 */
@Component
@ConfigurationProperties("custom.swagger")
@Data
public class SwaggerProperties implements Serializable {

    @ApiModelProperty("是否开启swagger")
    private boolean enabled;

    @ApiModelProperty("基础包")
    private String basePackage;

    @ApiModelProperty("swagger基础信息")
    private ApiInfoProperties apiInfo = new ApiInfoProperties();

    @ApiModelProperty("全局参数")
    private List<ApiGlobalProperties> globalParam;

}
