package top.doudou.swagger;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.Collections;
import java.util.List;

/**
 * @Description swagger的通用配置
 * @author 傻男人<244191347@qq.com>
 * @Date 2020-10-14 15:06
 * @Version V1.0
 */
@Configuration
@EnableSwagger2
@EnableKnife4j
@ConditionalOnProperty(name = "custom.swagger.enabled",havingValue = "true",matchIfMissing = false)
@EnableConfigurationProperties(SwaggerProperties.class)
public class Swagger2Configure {

    @Autowired
    private SwaggerProperties swaggerProperties;

    @Bean
    public Docket createRestApi() {
        return defaultDocket(swaggerProperties.getApiInfo().getTitle(),swaggerProperties.getBasePackage(),null);
    }

    private Docket defaultDocket(String groupName,String basePackage,String groupTitle){
        return new Docket(DocumentationType.SWAGGER_2)
                .enable(swaggerProperties.isEnabled())
                .useDefaultResponseMessages(false)
                .apiInfo(StringUtils.isBlank(groupTitle)?apiInfo():new ApiInfoBuilder().title(groupTitle).build())
                .globalOperationParameters(parameter())
                .select()
                .apis(StringUtils.isBlank(basePackage)
                        ? RequestHandlerSelectors.any() : RequestHandlerSelectors.basePackage(basePackage))
                .paths(PathSelectors.any())
                .build();
        // 授权信息全局应用
//                .securityContexts(securityContexts())
        // 授权信息设置，必要的header token等认证信息
//                .securitySchemes(securitySchemes())
        //支持的通讯协议集合
//                .protocols(Sets.newHashSet("https", "http"));
    }


    /**
     * 全局的参数
     * @return
     */
    private List<Parameter> parameter(){
        List<ApiGlobalProperties> globalParam =swaggerProperties.getGlobalParam();
        List<Parameter> pars = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(globalParam)){
            globalParam.forEach(item->{
                ParameterBuilder tokenPar = new ParameterBuilder();
                if(StringUtils.isNotEmpty(item.getName()))  tokenPar.name(item.getName());
                if(StringUtils.isNotEmpty(item.getDescription()))  tokenPar.description(item.getDescription());
                if(StringUtils.isNotEmpty(item.getType()))  tokenPar.modelRef(new ModelRef(item.getType()));
                if(StringUtils.isNotEmpty(item.getParameterType()))  tokenPar.parameterType(item.getParameterType());
                tokenPar.required(item.isRequired()).build();
                pars.add(tokenPar.build());
            });
        }else {
            ParameterBuilder tokenPar = new ParameterBuilder();
            tokenPar.name("Authorization").description("访问令牌").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
            pars.add(tokenPar.build());
        }
        return pars;
    }

    /**
     * API 页面上半部分展示信息
     * @return
     */
    private ApiInfo apiInfo() {
        ApiInfoProperties apiInfo = swaggerProperties.getApiInfo();
        if(null == apiInfo){
            return ApiInfo.DEFAULT;
        }
        return new ApiInfoBuilder()
                .title(apiInfo.getTitle())
                .version(apiInfo.getVersion())
                .description(apiInfo.getVersion())
                .contact(new Contact(apiInfo.getName(),apiInfo.getUrl(),apiInfo.getEmail()))
                .license(apiInfo.getLicense())
                .licenseUrl(apiInfo.getLicenseUrl())
                .build();
    }

    /**
     * 设置授权信息
     */
    private List<SecurityScheme> securitySchemes() {
        return Collections.emptyList();
//        ApiKey apiKey = new ApiKey("BASE_TOKEN", "token", In.HEADER.toValue());
//        return Collections.singletonList(apiKey);
    }


}
