/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.swagger;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import top.doudou.swagger.ApiGlobalProperties;
import top.doudou.swagger.ApiInfoProperties;
import top.doudou.swagger.SwaggerProperties;

@Configuration
@EnableSwagger2
@EnableKnife4j
@ConditionalOnProperty(name={"custom.swagger.enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={SwaggerProperties.class})
public class Swagger2Configure {
    @Autowired
    private SwaggerProperties swaggerProperties;

    @Bean
    public Docket createRestApi() {
        return this.defaultDocket(this.swaggerProperties.getApiInfo().getTitle(), this.swaggerProperties.getBasePackage(), null);
    }

    private Docket defaultDocket(String groupName, String basePackage, String groupTitle) {
        return new Docket(DocumentationType.SWAGGER_2).enable(this.swaggerProperties.isEnabled()).useDefaultResponseMessages(false).apiInfo(StringUtils.isBlank((CharSequence)groupTitle) ? this.apiInfo() : new ApiInfoBuilder().title(groupTitle).build()).globalOperationParameters(this.parameter()).select().apis(StringUtils.isBlank((CharSequence)basePackage) ? RequestHandlerSelectors.any() : RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any()).build();
    }

    private List<Parameter> parameter() {
        List<ApiGlobalProperties> globalParam = this.swaggerProperties.getGlobalParam();
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        if (CollectionUtils.isNotEmpty(globalParam)) {
            globalParam.forEach(item -> {
                ParameterBuilder tokenPar = new ParameterBuilder();
                if (StringUtils.isNotEmpty((CharSequence)item.getName())) {
                    tokenPar.name(item.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getDescription())) {
                    tokenPar.description(item.getDescription());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getType())) {
                    tokenPar.modelRef((ModelReference)new ModelRef(item.getType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getParameterType())) {
                    tokenPar.parameterType(item.getParameterType());
                }
                tokenPar.required(item.isRequired()).build();
                pars.add(tokenPar.build());
            });
        } else {
            ParameterBuilder tokenPar = new ParameterBuilder();
            tokenPar.name("Authorization").description("\u8bbf\u95ee\u4ee4\u724c").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build();
            pars.add(tokenPar.build());
        }
        return pars;
    }

    private ApiInfo apiInfo() {
        ApiInfoProperties apiInfo = this.swaggerProperties.getApiInfo();
        if (null == apiInfo) {
            return ApiInfo.DEFAULT;
        }
        return new ApiInfoBuilder().title(apiInfo.getTitle()).version(apiInfo.getVersion()).description(apiInfo.getVersion()).contact(new Contact(apiInfo.getName(), apiInfo.getUrl(), apiInfo.getEmail())).license(apiInfo.getLicense()).licenseUrl(apiInfo.getLicenseUrl()).build();
    }

    private List<SecurityScheme> securitySchemes() {
        return Collections.emptyList();
    }
}

