package top.doudou.common.cloud;

import org.apache.commons.lang3.StringUtils;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;


/**
 * @Description  云存储(支持七牛、阿里云、腾讯云)
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-03 14:51
 * @Version V1.0
 */
public abstract class AbstractCloudStorageService {
    /** 云存储配置信息 */
    CloudStorageProperties config;

    /**
     * 文件路径
     * @param prefix 前缀
     * @param suffix 后缀
     * @return 返回上传路径
     */
    public String getPath(String prefix, String suffix) {
        //生成uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        String path = new SimpleDateFormat("yyyyMMdd").format(new Date()) + "/" + uuid;
        if(StringUtils.isNotBlank(prefix)){
            path = prefix + "/" + path;
        }
        return String.format("%s.%s", config.getDomain(), suffix);
    }

    /**
     * 文件上传
     * @param data    文件字节数组
     * @param path    文件的指定存放路径（包含文件的文件名且为路径前缀的子目录）
     * @return        返回http地址
     */
    public abstract String upload(byte[] data, String path);

    /**
     * 文件上传
     * @param data     文件字节数组
     * @param suffix   后缀(一般为文件的类型比如jgp)
     * @return         返回http地址
     */
    public abstract String uploadSuffix(byte[] data, String suffix);


    /**
     * 文件上传
     * @param data     文件字节数组
     * @param prefix   路径前缀
     * @param suffix   后缀(一般为文件的类型比如jgp)
     * @return         返回http地址
     */
    public abstract String uploadSuffix(byte[] data,String prefix,String suffix);

    /**
     * 文件上传
     * @param inputStream   字节流
     * @param path          文件的指定存放路径（包含文件的文件名且为路径前缀的子目录）
     * @return              返回http地址
     */
    public abstract String upload(InputStream inputStream, String path);

    /**
     * 文件上传
     * @param inputStream  字节流
     * @param suffix       后缀(一般为文件的类型比如jgp)
     * @return             返回http地址
     */
    public abstract String uploadSuffix(InputStream inputStream, String suffix);

    /**
     * 文件上传
     * @param inputStream  字节流
     * @param prefix       路径前缀
     * @param suffix       后缀(一般为文件的类型比如jgp)
     * @return             返回http地址
     */
    public abstract String uploadSuffix(InputStream inputStream, String prefix,String suffix);

}
