package top.doudou.common.cloud;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * 文件上传Factory
 *
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
@Configuration
@EnableConfigurationProperties(CloudStorageProperties.class)
public class CloudStorageHandlerService {

    @Autowired
    private CloudStorageProperties config;

    @Bean
    public AbstractCloudStorageService cloudStorageService(){
        if(null == config.getType()){
            return new LocalCloudStorageService(config);
        }
        switch (config.getType()){
            case 1:
                return new QiniuCloudStorageService(config);
            case 2:
                return new AliyunCloudStorageService(config);
            case 3:
                return new QcloudCloudStorageService(config);
            default:
                return new LocalCloudStorageService(config);
        }
    }

}