package top.doudou.common.cloud;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.io.Serializable;

/**
 * 云存储配置信息
 *
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
@Data
@ApiModel(value = "云存储配置信息")
@Configuration
@ConfigurationProperties(prefix = "cloud.storage")
public class CloudStorageProperties implements Serializable {

    private static final long serialVersionUID = 8797516600503181786L;

    @ApiModelProperty(value = "类型 1：七牛  2：阿里云  3：腾讯云 4：本地上传")
    private Integer type;

    @ApiModelProperty(value = "绑定的域名")
    private String domain;

    @ApiModelProperty(value = "路径前缀(固定前缀可以为空)")
    private String prefix;

    @ApiModelProperty(value = "七牛云为accessKey阿里云AccessKeyId腾讯云SecretId")
    private String accessKey;

    @ApiModelProperty(value = "七牛secretKey阿里云AccessKeySecret腾讯云SecretKey")
    private String secretKey;

    @ApiModelProperty(value = "存储空间名")
    private String bucketName;


    @ApiModelProperty(value = "阿里云地域节点")
    private String endPoint;

    @ApiModelProperty(value = "腾讯云AppId")
    private Integer appId;

    @ApiModelProperty(value = "腾讯云COS所属地区")
    private String region;

    @ApiModelProperty(value = "本地上传存储目录")
    private String localPath;

}
